<?php

namespace App\Http\Controllers\Staff\Auth;

use App\Http\Controllers\Controller;
use App\Models\Staff;
use App\Models\StaffPasswordReset;
use Illuminate\Http\Request;

class ForgotPasswordController extends Controller {
    public function showLinkRequestForm() {
        $pageTitle = "Account Recovery";
        return view('staff.auth.passwords.email', compact('pageTitle'));
    }

    public function sendResetCodeEmail(Request $request) {
        $request->validate([
            'value' => 'required',
        ]);

        if (!verifyCaptcha()) {
            $notify[] = ['error', 'Invalid captcha provided'];
            return back()->withNotify($notify);
        }

        $fieldType = $this->findFieldType();
        $staff     = Staff::where($fieldType, $request->value)->first();

        if (!$staff) {
            $notify[] = ['error', 'The account could not be found'];
            return back()->withNotify($notify);
        }

        StaffPasswordReset::where('email', $staff->email)->delete();
        $code                 = verificationCode(6);
        $password             = new StaffPasswordReset();
        $password->email      = $staff->email;
        $password->token      = $code;
        $password->created_at = \Carbon\Carbon::now();
        $password->save();

        $userBrowserInfo = osBrowser();
        notify($staff, 'PASS_RESET_CODE', [
            'code' => $code,
            'operating_system' => isset($userBrowserInfo['os_platform']) ? $userBrowserInfo['os_platform'] : '',
            'browser' => isset($userBrowserInfo['browser']) ? $userBrowserInfo['browser'] : '',
            'ip' => getRealIp(),
            'time' => date('Y-m-d h:i:s A')
        ],['email']);

        $email = $staff->email;
        session()->put('pass_res_mail', $email);
        $notify[] = ['success', 'Password reset email sent successfully'];
        return to_route('staff.password.code.verify')->withNotify($notify);
    }

    public function findFieldType() {
        $input = request()->input('value');

        $fieldType = filter_var($input, FILTER_VALIDATE_EMAIL) ? 'email' : 'username';
        request()->merge([$fieldType => $input]);
        return $fieldType;
    }

    public function codeVerify(Request $request) {
        $pageTitle = 'Verify Email';
        $email     = $request->session()->get('pass_res_mail');
        if (!$email) {
            $notify[] = ['error', 'Oops! session expired'];
            return to_route('user.password.request')->withNotify($notify);
        }
        return view('staff.auth.passwords.code_verify', compact('pageTitle', 'email'));
    }

    public function verifyCode(Request $request) {
        $request->validate([
            'code'  => 'required',
            'email' => 'required',
        ]);
        $code = str_replace(' ', '', $request->code);


        if (StaffPasswordReset::where('token', $code)->where('email', $request->email)->count() != 1) {
            $notify[] = ['error', 'Verification code doesn\'t match'];
            return to_route('user.password.request')->withNotify($notify);
        }
        $notify[] = ['success', 'You can change your password'];
        session()->flash('fpass_email', $request->email);
        return to_route('staff.password.reset', $code)->withNotify($notify);
    }

}
