<?php

namespace App\Http\Controllers\Staff;

use App\Http\Controllers\Controller;
use App\Models\PaidLog;

class CollectionController extends Controller
{
    public function index()
    {

        $segmentThree = request()->segment(3);
        $segmentFour = request()->segment(4);

        $collections = PaidLog::where('staff_id', auth('staff')->id());

        switch ($segmentThree) {
            case 'loan':
                $pageTitle = 'Loan Collections';
                $collections->where('loan_id', '!=', 0);
                break;
            case 'savings':
                $pageTitle = 'Savings Collections';
                $collections->where('savings_id', '!=', 0);
                break;
            default:
                $pageTitle = 'Collections';
                break;
        }

        $collections = $collections->groupByRaw("DATE_FORMAT(created_at, '%Y-%m-%d')")
                                   ->selectRaw('*, sum(final_amount) as total_amount, count(*) as count');

        switch ($segmentFour) {
            case 'pending':
                $pageTitle = 'Pending ' . $pageTitle;
                $collections->where('admin_receive', 0);
                break;
            case 'paid':
                $pageTitle = 'Paid ' . $pageTitle;
                $collections->where('admin_receive', 1);
                break;
        }

        $collections = $collections->with('staff')->latest()->paginate(getPaginate());

        return view('staff.collection', compact('pageTitle', 'collections'));
    }


}
