<?php

namespace App\Lib;

use App\Constants\Status;
use App\Models\Loan;
use App\Lib\FormProcessor;
use App\Models\Form;

class LoanProcess
{
    public $plan;
    public $user;
    public $staffId;
    public $installment;
    public $lateFee;
    public $amountWithLateFee;

    public function __construct($data)
    {
        $this->plan = @$data['plan'];
        $this->user = @$data['user'];
        $this->staffId = @$data['staff_id'];
    }

    public function apply()
    {
        $plan = $this->plan;
        $user = $this->user;
        $staffId = $this->staffId;
        $loan = new Loan();
        $request = request();
        $form = Form::where('act', 'loan_form')->where('id', $plan->form_id)->firstOrFail();
        $formData = $form->form_data;
        $formProcessor = new FormProcessor();
        $validationRule = $formProcessor->valueValidation($formData);
        $request->validate($validationRule);



        foreach (@$loan->user_information ?? [] as $userData) {
            if ($userData->type == 'file') {
                fileManager()->removeFile(getFilePath('verify') . '/' . $userData->value);
            }
        }
        
        $userData = $formProcessor->processFormData($request, $formData);
        $loan->user_information    =  $userData;
        $loan->user_id              = $user->id;
        $loan->staff_id             = $staffId ?? 0;
        $loan->loan_plan_id         = $plan->id;
        $loan->loan_amount          = $plan->loan_amount;
        $loan->payable_amount       = $plan->payable_amount;
        $loan->installment          = $plan->installment;
        $loan->installment_interval = $plan->installment_interval;
        $loan->total_installment    = $plan->total_installment;
        $loan->next_installment     = now()->addDays($plan->installment_interval);
        $loan->late_fee             = $plan->fixed_late_fee + ($plan->installment * $plan->percent_late_fee / 100);
        $loan->status               = Status::LOAN_PENDING;
        $loan->save();
        return ;
    }

    public function installment($loan)
    {
        if ($loan->status == Status::LOAN_PENDING) {
            $notify[] = ['error', 'This loan has not been approved yet'];
            return [
                'error'  => true,
                'notify' => $notify
            ];
        } elseif ($loan->status == Status::LOAN_PAID) {
            $notify[] = ['error', 'All installments have been paid for this loan'];
            return [
                'error'  => true,
                'notify' => $notify
            ];
        } elseif ($loan->status == Status::LOAN_CLOSED) {
            $notify[] = ['error', 'This loan already closed'];
            return [
                'error'  => true,
                'notify' => $notify
            ];
        }

        $this->installmentCalculation($loan);
        return [
            'error' => false,
            'loan' => $loan
        ];
    }

    public function updateLoan($loan)
    {
        $this->installmentCalculation($loan);

        $loan->total_paid          += $this->installment;
        $loan->installment_given   += 1;
        $loan->total_late_fee_paid += $this->lateFee;
        $loan->last_installment     = now();
        $loan->next_installment     = $loan->next_installment->addDays($loan->installment_interval);
        if ($loan->total_installment == $loan->installment_given) {
            $loan->status = Status::LOAN_PAID;
        }
        $loan->save();
    }

    public function installmentCalculation($loan)
    {
        $lateFee                 = $loan->next_installment < now()->format('Y-m-d') ? $loan->late_fee : 0;
        $amountWithLateFee       = $loan->installment + $lateFee;
        $this->installment       = $loan->installment;
        $this->lateFee           = $lateFee;
        $this->amountWithLateFee = $amountWithLateFee;
    }
}
