<?php

namespace App\Models;

use App\Constants\Status;
use Illuminate\Database\Eloquent\Model;

class PaidLog extends Model
{
    public function loan()
    {
        return $this->belongsTo(Loan::class);
    }
    public function savings()
    {
        return $this->belongsTo(Savings::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function staff()
    {
        return $this->belongsTo(Staff::class);
    }

    public function scopeSuccess($query)
    {
        return $query->where('status', Status::PAID_SUCCESS);
    }
    public function scopePending($query)
    {
        return $query->where('status', Status::PAID_PENDING);
    }
    public function scopeCancel($query)
    {
        return $query->where('status', Status::PAID_CANCEL);
    }
}
