<?php

namespace App\Models;

use App\Constants\Status;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;

class Savings extends Model
{
    protected $casts = [
        'user_information' => 'object',
        'last_installment' => 'date',
        'next_installment' => 'date'
    ];

    public function savingsPlan()
    {
        return $this->belongsTo(SavingsPlan::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function staff()
    {
        return $this->belongsTo(Staff::class);
    }

    public function paidLogs()
    {
        return $this->hasMany(PaidLog::class);
    }

    //Scope
    public function scopePending()
    {
        return $this->where('status', Status::SAVINGS_PENDING);
    }

    public function scopeActive()
    {
        return $this->where('status', Status::SAVINGS_ACTIVE);
    }

    public function scopePaid()
    {
        return $this->where('status', Status::SAVINGS_PAID);
    }

    public function scopeClosed()
    {
        return $this->where('status', Status::SAVINGS_CLOSED);
    }

    public function scopePendingMatured(){
        return $this->paid()->where('transfer_user', 0);
    }

    public function scopePaidMatured(){
        return $this->paid()->where('transfer_user', 1);
    }

//     @if($savings->status == 0)
//     <span class="text--small badge badge--warning">@lang('Pending')</span>
// @elseif($savings->status == 1)
//     <span class="text--small badge badge--primary">@lang('Active')</span>
// @elseif($savings->status == 2)
//     <span class="text--small badge badge--success">@lang('Paid')</span>
// @else
//     <span class="text--small badge badge--danger">@lang('Close')</span>
// @endif
    
    public function statusBadge(): Attribute
    {
        return new Attribute(function () {
            $html = '';
            if ($this->status == Status::SAVINGS_PENDING) {
                $html = '<span class="badge badge--warning">' . trans("Pending") . '</span>';
            } elseif ($this->status == Status::SAVINGS_ACTIVE) {
                $html = '<span class="badge badge--success">' . trans("Active") . '</span>';
            } elseif ($this->status == Status::SAVINGS_PAID) {
                $html = '<span class="badge badge--primary">' . trans("Paid") . '</span>';
            } elseif ($this->status == Status::SAVINGS_CLOSED) {
                $html = '<span class="badge badge--dark">' . trans("Closed") . '</span>';
            }
            return $html;
        });
    }
}
