<?php

namespace App\Models;

use App\Constants\Status;
use App\Traits\StaffNotify;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Staff extends Authenticatable
{
    use StaffNotify;
    protected $table = 'staffs';
    protected $casts = [
        'email_verified_at' => 'datetime',
        'ver_code_send_at' => 'datetime',
    ];

    protected $guarded = ['id'];

    public function loginLogs()
    {
        return $this->hasMany(UserLogin::class);
    }

    // SCOPES

    public function getFullnameAttribute()
    {
        return $this->firstname . ' ' . $this->lastname;
    }
    // SCOPES
    public function scopeActive($query)
    {
        return $query->where('status', Status::STAFF_ACTIVE);
    }

    public function scopeBanned($query)
    {
        return $query->where('status', Status::STAFF_BAN);
    }

    public function scopeEmailUnverified($query)
    {
        return $query->where('ev', Status::UNVERIFIED);
    }

    public function scopeMobileUnverified($query)
    {
        return $query->where('sv', Status::UNVERIFIED);
    }


    public function scopeEmailVerified($query)
    {
        return $query->where('ev', Status::VERIFIED);
    }

    public function scopeMobileVerified($query)
    {
        return $query->where('sv', Status::VERIFIED);
    }

    public function tickets()
    {
        return $this->hasMany(SupportTicket::class);
    }
}
