@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('S.N.')</th>
                                    <th>@lang('User Name')</th>
                                    @if (request()->routeIs('admin.collection.index'))
                                        <th>@lang('Type')</th>
                                    @endif
                                    <th>@lang('Plan')</th>
                                    <th>@lang('Collected By')</th>
                                    <th>@lang('Amount')</th>
                                    <th>@lang('Date')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($collections as $collection)
                                    <tr>
                                        <td>{{ $collections->firstItem() + $loop->index }}</td>
                                        <td><a href="{{ route('admin.users.detail', $collection->user->id) }}">{{ __($collection->user->username) }}</a></td>
                                        @if (request()->routeIs('admin.collection.index'))
                                            <td data-label="@lang('Type')">
                                                @if ($collection->loan_id)
                                                    @lang('Loan')
                                                @else
                                                    @lang('Savings')
                                                @endif
                                            </td>
                                        @endif

                                        <td>
                                            @if ($collection->loan_id)
                                                {{ $collection->loan->loanPlan->name ?? 'N/A' }}
                                            @elseif ($collection->savings_id)
                                                {{ $collection->savings->savingsPlan->name ?? 'N/A' }}
                                            @else
                                                @lang(' N/A')
                                            @endif
                                        </td>
                                        <td>
                                            @if ($collection->staff_id)
                                                <a href="{{ route('admin.staffs.detail', $collection->staff->id) }}">{{ __($collection->staff->username) }}</a>
                                            @elseif(!$collection->trx)
                                                @lang('Admin')
                                            @else
                                                @lang('Self')
                                            @endif
                                        </td>
                                        <td>{{ showAmount($collection->amount) }}</td>
                                        <td>{{ showDateTime($collection->created_at, 'M d, Y - h:i a') }}</td>
                                        <td>
                                            <div class="button--group">
                                            <button class="btn btn-outline--primary btn-sm details-btn" data-toggle="tooltip" data-original-title="@lang('Details')" data-user_name="{{ __($collection->user->fullname) ?? 'N/A' }}" data-user_email="{{ $collection->user->email ?? 'N/A' }}" data-plan_name="{{ $collection->loan_id ? __($collection->loan->loanPlan->name ?? 'N/A') : __($collection->savings->savingsPlan->name ?? 'N/A') }}" data-interval="{{ $collection->loan_id ? installmentInterval($collection->loan->installment_interval ?? 0, $days) : installmentInterval($collection->savings->installment_interval ?? 0, $days) }}@lang(' Payable')" data-amount="{{ showAmount($collection->amount) }}" data-late_fee="{{ showAmount($collection->late_fee) }}" data-final_amount="{{ showAmount($collection->final_amount) }}" title="">
                                                <i class="las la-desktop"></i> @lang('Details')
                                            </button>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($collections->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($collections) }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    {{-- COLLECTIONS DETAILS MODAL  --}}
    <div class="modal fade" id="collectionModal" role="dialog" tabindex="-1">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Collection Details')</h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('User Name'):
                            <span class="user-name"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('User Email'):
                            <span class="user-email"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Plan Name'):
                            <span class="plan-name"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Type'):
                            <span class="loan-type"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Amount'):
                            <span class="amount"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Late Fee'):
                            <span class="late-fee"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Total Amount'):
                            <span class="total-amount"></span>
                        </li>
                    </ul>
                </div>
                <div class="modal-footer">
                    <button class="btn btn--dark" data-bs-dismiss="modal">@lang('Close')</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    <x-search-form placeholder="User/Staff" />
@endpush

@push('script')
    <script>
        "use strict";
        (function($) {
            $('.details-btn').on('click', function() {
                var modal = $('#collectionModal');
                var data = $(this).data();

                modal.find('.user-name').text(data.user_name);
                modal.find('.user-email').text(data.user_email);
                modal.find('.loan-type').text(data.interval)
                modal.find('.plan-name').text(data.plan_name);
                modal.find('.amount').text(data.amount);
                modal.find('.late-fee').text(data.late_fee);
                modal.find('.total-amount').text(data.final_amount);
                modal.modal('show');
            });

        })(jQuery);
    </script>
@endpush
