@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <form action="{{ route('admin.plan.loan.store', @$plan->id) }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('Name')</label>
                                    <input class="form-control" name="name" type="text" value="{{ old('name', @$plan->name) }}" required />
                                </div>
                            </div>
                            <div class="col-sm-12 col-xl-4 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Loan Amount')</label>
                                    <div class="input-group">
                                        <input class="form-control" name="loan_amount" type="number" value="{{ old('loan_amount', getAmount(@$plan->loan_amount)) }}" step="any" required />
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-12 col-xl-4 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Payable Amount') </label>
                                    <div class="input-group">
                                        <input class="form-control" name="payable_amount" type="number" value="{{ old('payable_amount', getAmount(@$plan->payable_amount)) }}" step="any" required />
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 col-xl-4 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Total Installement')</label>
                                    <input class="form-control" name="total_installment" type="number" value="{{ old('total_installment', getAmount(@$plan->total_installment)) }}" step="any" required />
                                </div>
                            </div>
                            <div class="col-sm-12 col-xl-4 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Installment Interval')</label>
                                    <select class="form-control" name="installment_interval" required>
                                        <option value="" hidden>@lang('Select One')</option>
                                        @foreach ($days as $day)
                                            <option value="{{ $day->day }}">{{ __($day->name) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-12 col-xl-4 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Per Installment')</label>
                                    <div class="input-group">
                                        <input class="form-control installment" type="number" step="any" readonly />

                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 col-xl-4 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Fixed Late Fee')</label>
                                    <div class="input-group">
                                        <input class="form-control" name="fixed_late_fee" type="number" value="{{ @$plan ? getAmount($plan->fixed_late_fee) : old('fixed_late_fee') }}" step="any" required />

                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 col-xl-4 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Percent Late Fee')</label>
                                    <div class="input-group">
                                        <input class="form-control" name="percent_late_fee" type="number" value="{{ @$plan ? getAmount($plan->percent_late_fee) : old('percent_late_fee') }}" step="any" required />
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 col-xl-4 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Profit')</label>
                                    <div class="input-group">
                                        <input class="form-control profit" type="number" step="any" readonly />
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group mt-3">
                                <label class=" ">@lang('Description')</label>
                                <textarea class="form-control border-radius-5 nicEdit" name="description" rows="8">{{ old('description', @$plan->description) }}</textarea>
                            </div>

                            <div class="col-lg-12">
                                <div class="submitRequired bg--warning form-change-alert d-none mt-3"><i class="fas fa-exclamation-triangle"></i> @lang('You\'ve to click on the submit button to apply the changes')</div>
                                <div class="card border--primary mt-3">
                                    <div class="card-header bg--primary d-flex justify-content-between">
                                        <h5 class="text-white">@lang('User Data')</h5>
                                        <button class="btn btn-sm btn-outline-light float-end form-generate-btn" type="button"> <i class="la la-fw la-plus"></i>@lang('Add New')</button>
                                    </div>
                                    <div class="card-body">
                                        <x-generated-form :form=@$form />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button class="btn btn--primary w-100 h-45" type="submit">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <x-form-generator-modal />
    
@endsection

@push('breadcrumb-plugins')
    <x-back route="{{ route('admin.plan.loan.index') }}" />
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            $('[name=installment_interval]').val({{ old('installment_interval') ?? @$plan->installment_interval }});

            var curSym = `{{ __(gs('cur_text')) }}`;

            receivableCalculation();

            $('[name=loan_amount], [name=payable_amount], [name=total_installment]').on('input', function(e) {
                receivableCalculation();
            });

            function receivableCalculation() {
                var loanAmount = parseInt($('[name=loan_amount]').val());
                var payableAmount = parseInt($('[name=payable_amount]').val());
                var totalInstallment = parseInt($('[name=total_installment]').val());
                var amount = payableAmount / totalInstallment;

                $('.installment').val(amount.toFixed(2));
                $('.profit').val(payableAmount - loanAmount);
            }


        })(jQuery);
    </script>
@endpush
