@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('S.N.')</th>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Savings Amount')</th>
                                    <th>@lang('Giveable Amount')</th>
                                    <th>@lang('Interval')</th>
                                    <th>@lang('Times')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($savingPlans as $plan)
                                    <tr>
                                        <td>{{ $savingPlans->firstItem() + $loop->index }}</td>
                                        <td>{{ __($plan->name) }}</td>
                                        <td>{{ showAmount($plan->savings_amount) }}</td>
                                        <td>{{ showAmount($plan->giveable_amount) }}</td>
                                        <td>{{ installmentInterval($plan->installment_interval, $days) }}</td>
                                        <td>{{ $plan->total_installment }}</td>
                                        <td>
                                            @php
                                                echo $plan->statusBadge;
                                            @endphp
                                        </td>
                                        <td>
                                            <div class="button--group">
                                                <a class="btn btn-sm btn-outline--primary ms-1 mb-2" href="{{ route('admin.plan.savings.edit', $plan->id) }}">
                                                    <i class="las la-pen"></i> @lang('Edit')
                                                </a>
                                                @if ($plan->status == Status::DISABLE)
                                                    <button class="btn btn-sm btn-outline--success ms-1 mb-2 confirmationBtn" data-action="{{ route('admin.plan.savings.status', $plan->id) }}" data-question="@lang('Are you sure to enable this plan?')" type="button">
                                                        <i class="la la-eye"></i> @lang('Enable')
                                                    </button>
                                                @else
                                                    <button class="btn btn-sm btn-outline--danger mb-2 confirmationBtn" data-action="{{ route('admin.plan.savings.status', $plan->id) }}" data-question="@lang('Are you sure to disable this plan?')" type="button">
                                                        <i class="la la-eye-slash"></i> @lang('Disable')
                                                    </button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($savingPlans->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($savingPlans) }}
                    </div>
                @endif
            </div>
        </div>
    </div>
    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <x-search-form placeholder="Search by Name" />
    <a class="btn btn-outline--primary" href="{{ route('admin.plan.savings.create') }}"><i class="las la-plus"></i>@lang('Add New')</a>
@endpush
