@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <form action="{{ route('admin.savings.register.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="row mb-none-15">
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('Username or Email')</label>
                                    <input class="form-control " name="user" type="text" value="{{ old('user') }}" required />
                                    <span class="text--danger email-check">@lang('No user found')</span>
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('User Name')</label>
                                    <input class="form-control user_info user_name" type="text" readonly />
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('User Mobile')</label>
                                    <input class="form-control user_info user_mobile" type="text" readonly />
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('User Address')</label>
                                    <input class="form-control user_info user_address" type="text" readonly />
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('User City')</label>
                                    <input class="form-control user_info user_city" type="text" readonly />
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('User Country')</label>
                                    <input class="form-control user_info user_country" type="text" readonly />
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('Select Savings Plan')</label>
                                    <select class="form-control select2" name="plan_id" required>
                                        <option value="" hidden>@lang('Select One')</option>
                                        @foreach ($plans as $plan)
                                            <option data-plan="{{ $plan }}" data-installment_interval="{{ __(installmentInterval($plan->installment_interval, $days)) }}@lang(' payable')" value="{{ $plan->id }}">{{ __($plan->name) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('Savings Amount')</label>
                                    <div class="input-group">
                                        <input class="form-control savings_amount" type="text" readonly />
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('Giveable Amount')</label>
                                    <div class="input-group">
                                        <input class="form-control giveable_amount" type="text" readonly />
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('Installment Interval')</label>
                                    <input class="form-control installment_interval" type="text" readonly />
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('Total Installment')</label>                                    
                                    <div class="input-group">
                                        <input class="form-control total_installment" type="text" readonly />
                                        <span class="input-group-text">@lang('Times')</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('Installment')</label>
                                    <div class="input-group">
                                        <input class="form-control installment" type="text" readonly />
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="card-footer">
                        <button class="btn btn--primary w-100 h-45" type="submit">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    <x-back route="{{ route('admin.savings.index') }}" />
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            $('.email-check').hide();

            $('[name=user]').on('change', function(e) {
                var user = e.target.value;
                var url = `{{ route('admin.users.check') }}`;

                $.ajax({
                    type: "POST",
                    url: url,
                    data: {
                        '_token': "{{ csrf_token() }}",
                        'user': user
                    },
                    success: function(response) {
                        if (!response) {
                            $('.email-check').show();
                            $('.user_info').val('');
                            $('[type=submit]').attr('disabled', true);
                        } else {
                            $('.email-check').hide();
                            $('.user_name').val(response.firstname + ' ' + response.lastname);
                            $('.user_mobile').val(response.mobile);
                            $('.user_address').val(response.address);
                            $('.user_city').val(response.city);
                            $('.user_country').val(response.country_name);
                            $('[type=submit]').attr('disabled', false);
                        }
                    }
                });

            });

            $('[name=plan_id]').on('change', function(e) {
                var plan = $(this).find(':selected').data().plan;
                var savingsAmount = parseInt(plan.savings_amount).toFixed(2);
                $('.savings_amount').val(savingsAmount);
                $('.giveable_amount').val(parseInt(plan.giveable_amount).toFixed(2));
                $('.total_installment').val(plan.total_installment);
                $('.installment').val((savingsAmount / plan.total_installment).toFixed(2));
                $('.installment_interval').val($(this).find(':selected').data('installment_interval'));

            });
        })(jQuery);
    </script>
@endpush
