@extends('staff.layouts.master')
@section('content')
    <div class="login-main" style="background-image: url('{{ asset('assets/admin/images/login.jpg') }}')">
        <div class="container custom-container">
            <div class="row justify-content-center">
                <div class="col-xxl-5 col-xl-5 col-lg-6 col-md-8 col-sm-11">
                    <div class="login-area">
                        <div class="login-wrapper">
                            <div class="login-wrapper__top">
                                <h3 class="title text-white">@lang('Recovery Account')</h3>
                            </div>
                            <div class="login-wrapper__body">
                                <form method="POST" action="{{ route('staff.password.email') }}" class="verify-gcaptcha">
                                    @csrf
                                    <div class="form-group">
                                        <label>@lang('Email or Username')</label>
                                        <input type="text" class="form-control form--control" name="value" value="{{ old('value') }}" required autofocus="off">
                                    </div>

                                    <x-captcha />

                                    <div class="form-group">
                                        <button type="submit" class="btn btn--primary h-45 w-100">@lang('Submit')</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('style')
    <style>
        .form-control {
            color: #e7e7e7 !important;
        }

        .form-control:focus {
            color: #e7e7e7;
            background-color: transparent;
        }
    </style>
@endpush
