@extends('staff.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-xl-6">
            <div class="card mb-4">
                <div class="card-header">
                    <h5>@lang('Loan Plan Information')</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Plan Name')
                            <span>{{ __($plan->name) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Loan Amount')
                            <span>{{ showAmount($plan->loan_amount) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Payable Amount')
                            <span>{{ showAmount($plan->payable_amount) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Total Installment')
                            <span>{{ $plan->total_installment }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment Amount')
                            <span>{{ showAmount($plan->installment) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment Interval')
                            <span>{{ installmentInterval($plan->installment_interval, $days) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Late Fee')
                            <span> {{ showAmount($plan->fixed_late_fee + ($plan->installment * $plan->percent_late_fee / 100)) }}</span>
                        </li>
                        <li class="list-group-item">
                           @lang('Description') <hr class="mt-1 mb-2">
                           @php
                               echo $plan->description;
                           @endphp
                        </li>
                      </ul>
                </div>
            </div>
        </div>
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header">
                    <h5>@lang('Application Information')</h5>
                </div>
                <form  action="{{ route('staff.loan.apply', $plan->id) }}" class="disableSubmission" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="card-body">
                        <div class="form-group">
                            <label>@lang('Search: Username or Email')</label>
                            <input type="text" class="form-control" name="user" required>
                            <p class="message mt-1"></p>
                        </div>

                        <x-viser-form identifier="id" identifierValue="{{ $plan->form_id }}" />
                    </div>
                    <div class="card-footer">
                        <div class="form-group">
                            <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    <x-back route="{{route('user.loan.plan')}}" />
@endpush


@push('script')
    <script>
        (function ($) {
         "use strict";
         $('[name=user]').on('change', function(e){
                var user = e.target.value;
                var url = `{{ route('staff.user.check') }}`;

                $.ajax({
                    url: url,
                    method: 'POST',
                    data: { '_token': `{{ csrf_token() }}`, 'user': user },
                    success: function(response){
                        if(response){
                            $('.message').text('User: '+response.firstname+' '+response.lastname).addClass('text--success').removeClass('text--danger');
                        }else{
                            $('.message').text('User not found').addClass('text--danger').removeClass('text--success');
                        }
                    }     
                })
            });
        })(jQuery);
    </script>
@endpush
