@extends('user.layouts.app')
@section('panel')
<div class="row mb-none-30">
    <div class="col-xl-3 col-lg-4 mb-30">
        <div class="card b-radius--5 overflow-hidden">
            <div class="card-body p-0">
                <div class="d-flex p-3 bg--primary align-items-center">
                    <div class="avatar avatar--lg">
                        <img src="{{ getImage(getFilePath('userProfile').'/'. $user->image,getFileSize('userProfile'))}}" alt="Image">
                    </div>
                    <div class="ps-3">
                        <h4 class="text--white">{{__(@$user->fullname)}}</h4>
                    </div>
                </div>
                <ul class="list-group">
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        @lang('Name')
                        <span class="fw-bold">{{__(@$user->fullname)}}</span>
                    </li>

                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        @lang('Username')
                        <span  class="fw-bold">{{__($user->username)}}</span>
                    </li>

                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        @lang('Email')
                        <span  class="fw-bold">{{@$user->email}}</span>
                    </li>

                </ul>
            </div>
        </div>
    </div>

    <div class="col-xl-9 col-lg-8 mb-30">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title mb-4 border-bottom pb-2">@lang('Profile Information')</h5>

                <form  method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="col-xxl-4 col-lg-6">
                            <div class="form-group">
                                <label>@lang('Image')</label>
                                <x-image-uploader image="{{ $user->image }}" class="w-100" type="userProfile" :required=false />
                            </div>
                        </div>
                        <div class="col-xxl-8 col-lg-6">
                            <div class="row">
                                <div class="form-group col-sm-6">
                                    <label>@lang('First Name')</label>
                                    <input type="text" class="form-control form--control" name="firstname" value="{{$user->firstname}}" required>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label>@lang('Last Name')</label>
                                    <input type="text" class="form-control form--control" name="lastname" value="{{$user->lastname}}" required>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-sm-6">
                                    <label>@lang('E-mail Address')</label>
                                    <input class="form-control form--control" value="{{$user->email}}" readonly>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label>@lang('Mobile Number')</label>
                                    <input class="form-control form--control" value="{{$user->mobile}}" readonly>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-sm-6">
                                    <label>@lang('Address')</label>
                                    <input type="text" class="form-control form--control" name="address" value="{{@$user->address}}">
                                </div>
                                <div class="form-group col-sm-6">
                                    <label>@lang('State')</label>
                                    <input type="text" class="form-control form--control" name="state" value="{{@$user->state}}">
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-sm-4">
                                    <label>@lang('Zip Code')</label>
                                    <input type="text" class="form-control form--control" name="zip" value="{{@$user->zip}}">
                                </div>
        
                                <div class="form-group col-sm-4">
                                    <label>@lang('City')</label>
                                    <input type="text" class="form-control form--control" name="city" value="{{@$user->city}}">
                                </div>
        
                                <div class="form-group col-sm-4">
                                    <label>@lang('Country')</label>
                                    <input class="form-control form--control" value="{{@$user->country_name}}" disabled>
                                </div>
                            </div>
                        </div>
                    </div>
                    <button type="submit" class="btn btn--primary h-45 w-100">@lang('Submit')</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
