@extends('user.layouts.app')
@section('panel')
<div class="row">
    @foreLSE ($savingsPlans as $plan)     
        <div class="col-xl-4 col-md-6 my-4">
            <div class="card">
                <div class="card-body p-4 p-xxl-5">
                    <div class="pricing-table">
                    <h4 class="package-name">{{ __($plan->name) }}</h4>
                    <h4 class="price">{{ showAmount($plan->installment) }}</h4>
                    <span class="badge badge--primary text-end">{{ __(installmentInterval($plan->installment_interval, $days)) }}</span>
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                            @lang('Savings amount')
                            <span>{{ showAmount($plan->savings_amount) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                            @lang('Receivable amount')
                          <span>{{ showAmount($plan->giveable_amount) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                          @lang('Total Installment')
                          <span>{{ $plan->total_installment }}</span>
                        </li>
                      
                        <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                          @lang('Late Fee')
                          <span>{{ showAmount($plan->fixed_late_fee + ($plan->installment * $plan->percent_late_fee / 100)) }}</span>
                        </li>
                      </ul>
                    <a href="{{ route('user.savings.apply', $plan->id) }}" class="btn  btn--primary w-100 h-45">@lang('Apply Now')</a>
                    </div>
                </div>
            </div><!-- card end -->
        </div>
        @empty
        <div class="empty-message text-center">
            <img src="{{ asset('assets/images/empty_list.png') }}" alt="empty">
            <br>
            {{ __($emptyMessage) }}
        </div>
    @endforelse

    {{ paginateLinks($savingsPlans) }}
</div>
@endsection

