<?php

use Illuminate\Support\Facades\Route;

Route::namespace('Staff\Auth')->name('staff.')->group(function () {

    Route::middleware('staff.guest')->group(function () {
        Route::controller('LoginController')->group(function () {
            Route::get('/', 'showLoginForm')->name('login');
            Route::post('/', 'login');
            Route::get('logout', 'logout')->middleware('staff')->withoutMiddleware('staff.guest')->name('logout');
        });

        Route::controller('ForgotPasswordController')->prefix('password')->name('password.')->group(function () {
            Route::get('reset', 'showLinkRequestForm')->name('request');
            Route::post('email', 'sendResetCodeEmail')->name('email');
            Route::get('code-verify', 'codeVerify')->name('code.verify');
            Route::post('verify-code', 'verifyCode')->name('verify.code');
        });

        Route::controller('ResetPasswordController')->group(function () {
            Route::post('password/reset', 'reset')->name('password.update');
            Route::get('password/reset/{token}', 'showResetForm')->name('password.reset');
        });
    });
});

Route::middleware('staff')->name('staff.')->group(function () {

    //authorization
    Route::middleware('staff')->namespace('Staff')->controller('AuthorizationController')->group(function () {
        Route::get('authorization', 'authorizeForm')->name('authorization');
        Route::get('resend-verify/{type}', 'sendVerifyCode')->name('send.verify.code');
        Route::post('verify-email', 'emailVerification')->name('verify.email');
        Route::post('verify-mobile', 'mobileVerification')->name('verify.mobile');
        Route::post('verify-g2fa', 'g2faVerification')->name('2fa.verify');
    });

    Route::middleware('check.staff.status')->namespace('Staff')->group(function () {

        Route::controller('StaffController')->group(function () {
            Route::get('dashboard', 'home')->name('home');

            //2FA
            Route::get('twofactor', 'show2faForm')->name('twofactor');
            Route::post('twofactor/enable', 'create2fa')->name('twofactor.enable');
            Route::post('twofactor/disable', 'disable2fa')->name('twofactor.disable');

            Route::post('user-check', 'checkUser')->name('user.check');

            //Payment History
            Route::get('payment-history/all', 'paymentHistory')->name('payment.history');
            Route::get('payment-history/loan/{filter?}/{adminReceive?}', 'paymentHistory')->name('payment.loan.history');
            Route::get('payment-history/savings/{filter?}/{adminReceive?}', 'paymentHistory')->name('payment.savings.history');
        });

        //LoanController
        Route::controller('LoanController')->name('loan.')->prefix('loan')->group(function () {
            Route::get('plans', 'plan')->name('plan');
            Route::get('apply/{plan}', 'applyForm')->name('apply');
            Route::post('apply/{plan}', 'apply');
            Route::get('/pending', 'index')->name('pending');
            Route::get('active', 'index')->name('active');
            Route::get('paid', 'index')->name('paid');
            Route::get('index', 'index')->name('index');
            Route::get('closed', 'index')->name('closed');
            Route::post('installment', 'installment')->name('installment');
        });

        //SavingsController
        Route::controller('SavingsController')->name('savings.')->prefix('savings')->group(function () {
            Route::get('plans', 'plan')->name('plan');
            Route::get('apply/{plan}', 'applyForm')->name('apply');
            Route::post('apply/{plan}', 'apply');
            Route::get('pending', 'index')->name('pending');
            Route::get('active', 'index')->name('active');
            Route::get('paid', 'index')->name('paid');
            Route::get('closed', 'index')->name('closed');
            Route::get('index', 'index')->name('index');
            Route::post('installment', 'installment')->name('installment');
        });

        //Collection
        Route::controller('CollectionController')->name('collection.')->prefix('collection')->group(function () {
            Route::get('loan/pending', 'index')->name('loan.pending');
            Route::get('savings/pending', 'index')->name('savings.pending');
            Route::get('loan/paid', 'index')->name('loan.paid');
            Route::get('savings/paid', 'index')->name('savings.paid');
        });

        //Profile setting
        Route::controller('ProfileController')->group(function () {
            Route::get('profile-setting', 'profile')->name('profile.setting');
            Route::post('profile-setting', 'submitProfile');
            Route::get('change-password', 'changePassword')->name('change.password');
            Route::post('change-password', 'submitPassword');
        });

        // User Support Ticket
        Route::controller('TicketController')->prefix('ticket')->name('ticket.')->group(function () {
            Route::get('/', 'supportTicket')->name('index');
            Route::get('new', 'openSupportTicket')->name('open');
            Route::post('create', 'storeSupportTicket')->name('store');
            Route::get('view/{ticket}', 'viewTicket')->name('view');
            Route::post('reply/{id}', 'replyTicket')->name('reply');
            Route::post('close/{id}', 'closeTicket')->name('close');
            Route::get('download/{attachment_id}', 'ticketDownload')->name('download');
        });
    });
});
